	function [N, Be, D, W] = HERRMANN_LP_FIR_ORDER(wT, d)
	
	%	Herrmanns estimate of the required order, N, for minimax designed  
	%	linear-phase lowpass FIR filters. 
	%	L = filter length (No of samples in the impulse response) is L = N + 1.
	%
	%   inputs:
	%	  wT = [wcT wsT]
	%     wcT: passband cutoff edge (NORMALIZED 0 < wcT < )
	%     wsT: stopband cutoff edge > wcT 
	%	  d = [dc ds]
	%     dc: passband ripple 
	%     ds: stopband ripple < dc
	%
	%	outputs:
	%
	%	Formated for direct use by MPR_FIR.m and firmp.m or remez.m	
	% 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2004-07-17
	% 	Modified by: 	LW 2005-05-09
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	% 	References:	[1] Herrmann O., Rabiner L.R., and Chan D S K.:  Practical 
	% 					design rules for optimum finite impulse response lowpass digital 
	% 					filters, Bell System Techical Journal, vol. 52 (July-August), 1973.
	%				[2] Rabiner & Gold, Theory and Appications of DSP, pp. 156-7.     
	
	if (wT(1) >= wT(2) | wT(1) >= pi | wT(2) > pi)
		error('Improper band edges. Edges should be: wcT < wsT <= .')
	end				
	wcT = wT(1);		% Passband edge
	wsT = wT(2);		% Stopband edge
	dwT = wsT - wcT;	% Transition band
	dc = d(1);
	ds = d(2);
	a1 = 5.309*10^-3;
	a2 = 7.114*10^-2;
	a3 = -0.4761;
	a4 = -2.66*10^-3;
	a5 = -0.5941;
	a6 = -0.4278;
	b1 = 11.01217;
	b2 = 0.51244;
	ldc = log10(dc);
	lds = log10(ds);
	% If the passband ripple is smaller, then interchange the roles of the
	% ripples; comment by Tapio - for sure, this can be found [1] after careful
	% reading
	if dc < ds
		d2 = log10(dc);
		d1 = log10(ds); 
	end
	F = b1 + b2*(ldc - lds);
	D = (a1*ldc^2 + a2*ldc + a3)*lds + (a4*ldc^2 + a5*ldc + a6);
	Tpi = 2*pi;
	N = ceil(Tpi*D/dwT - F*dwT/Tpi);
	%	N = Tpi*D/dwT - F*dwT/Tpi;  % Used in FIGURE 5.35
	Be = [0 wcT wsT pi]';
	D = [1 1 0 0]';
	W = [1 d(1)/d(2)]';
	
